

<?php $__env->startSection('title', 'Department of Rachana Sharir | Ayurvedic Anatomy Department'); ?>

<?php $__env->startSection('meta_description', 'Department of Rachana Sharir (Ayurvedic Anatomy) offering cadaveric dissection, anatomical
    training, museum facilities, and foundational structural sciences for BAMS education.'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Optional: Add your custom styles here -->
    <style>
        /* =========================
        GLOBAL STYLES
        ========================= */

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', 'Open Sans', Arial, sans-serif;
            font-size: 16px;
            line-height: 1.7;
            color: #333;
            background-color: #ffffff;
        }


        ul {
            list-style-image: url('bullet.png');
            /* Path to your bullet image */
            list-style-type: disc;
            /* Fallback if image is not available */
        }

        h1,
        h2,
        h3 {
            font-family: 'Poppins', 'Montserrat', sans-serif;
            color: #1f2a44;
            margin-bottom: 15px;
        }

        h1 {
            font-size: 36px;
        }

        h2 {
            font-size: 28px;
        }

        p {
            margin-bottom: 15px;
        }

        a {
            text-decoration: none;
            color: #1a4ed8;
        }

        a:hover {
            text-decoration: underline;
        }

        /* =========================
                                                    LAYOUT
                                                    ========================= */

        .container {
            max-width: 1100px;
            margin: auto;
            padding: 0 20px;
        }

        .section {
            padding: 60px 0;
        }

        .bg-light {
            background-color: #f7f9fc;
        }

        .bg-primary {
            background-color: #1f2a44;
        }

        /* =========================
                                                    HERO SECTION
                                                    ========================= */

        .hero-section {
            background: linear-gradient(rgba(31, 42, 68, 0.7),
                    rgba(31, 42, 68, 0.7)),
                url('campus-photo.jpg') center/cover no-repeat;
            text-align: center;
            padding: 100px 20px;
            color: #ffffff;
        }

        .hero-section h1 {
            color: #ffffff;
            font-size: 42px;
        }

        .hero-section p {
            font-size: 18px;
            margin-bottom: 30px;
        }

        /* =========================
                                                    BUTTONS
                                                    ========================= */

        .btn {
            display: inline-block;
            padding: 12px 26px;
            margin: 5px;
            border-radius: 6px;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .btn.primary {
            background-color: #f0b429;
            color: #1f2a44;
        }

        .btn.primary:hover {
            background-color: #d99b1f;
        }

        .btn.secondary {
            background-color: transparent;
            border: 2px solid #ffffff;
            color: #ffffff;
        }

        .btn.secondary:hover {
            background-color: #ffffff;
            color: #1f2a44;
        }

        /* =========================
                                                    LISTS & CONTENT
                                                    ========================= */

        .strength-list,
        .leadership-list,
        .important-links {
            list-style: none;
            padding-left: 0;
        }

        .strength-list li,
        .leadership-list li {
            padding: 10px 0;
            padding-left: 28px;
            position: relative;
        }

        .strength-list li::before {
            content: "✔";
            position: absolute;
            left: 0;
            color: #1a4ed8;
            font-weight: bold;
        }

        /* =========================
                                                    FACILITIES GRID
                                                    ========================= */

        .facility-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
            gap: 20px;
            margin-top: 30px;
        }

        .facility-item {
            background: #c9c7bf;
            padding: 25px;
            text-align: center;
            border-radius: 10px;
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.08);
            font-weight: 600;
        }

        /* =========================
                                                    LINKS SECTION
                                                    ========================= */

        .important-links li {
            margin-bottom: 10px;
        }

        .important-links a {
            color: #ffffff;
            font-weight: 500;
        }

        .section {
            padding: 30px 0;
        }

        /* =========================
                                                    FOOTER
                                                    ========================= */

        .footer {
            background-color: #f1f3f6;
            text-align: center;
            font-size: 14px;
            color: #666;
        }

        .footer p {
            margin: 0;
        }

        /* =========================
                                                    RESPONSIVE DESIGN
                                                    ========================= */

        @media (max-width: 768px) {
            h1 {
                font-size: 30px;
            }

            h2 {
                font-size: 24px;
            }

            .hero-section {
                padding: 70px 20px;
            }

            .btn {
                width: 100%;
                max-width: 280px;
            }
        }
    </style>
    <div class="container my-5">

        <!-- ================= PAGE HEADER ================= -->
        <header class="text-center mb-5">
            <h1 class="fw-bold">Department of Rachana Sharir</h1>
            <p class="text-muted">
                Ayurvedic Anatomy • Structural Sciences • Cadaveric Dissection • Foundational Medical Education
            </p>
        </header>


        <!-- ================= Department Overview ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Department Overview</h2>

            <p class="text-justify">
                The Department of Rachana Sharir focuses on the study of human body structure through
                classical Ayurvedic anatomy and modern anatomical sciences. The department builds
                strong foundational knowledge through cadaveric dissection, osteology, anatomical models,
                and museum-based learning, enabling students to correlate traditional Sharir concepts
                with contemporary biomedical understanding.
            </p>

            <ul>
                <li>Structural study of the human body</li>
                <li>Cadaveric dissection & demonstration</li>
                <li>Ayurvedic anatomical concepts (Sharir Rachana)</li>
                <li>Integration of classical and modern anatomy</li>
            </ul>
        </section>


        <!-- ================= Vision & Mission ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Vision & Mission</h2>

            <div class="row g-4">

                <div class="col-md-6">
                    <div class="card shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-semibold">Vision</h5>
                            <p>
                                To establish excellence in Ayurvedic anatomical education through scientific,
                                ethical, and hands-on learning that prepares competent healthcare professionals.
                            </p>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="card shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-semibold">Mission</h5>
                            <ul>
                                <li>Provide comprehensive anatomical training</li>
                                <li>Encourage experiential dissection-based learning</li>
                                <li>Promote research in Sharir studies</li>
                                <li>Integrate classical Ayurvedic texts with modern science</li>
                            </ul>
                        </div>
                    </div>
                </div>

            </div>
        </section>


        <!-- ================= Courses ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Courses & Teaching Programs</h2>

            <div class="table-responsive">
                <table class="table table-bordered table-striped align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Program</th>
                            <th>Year</th>
                            <th>Subject</th>
                            <th>Component</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>BAMS</td>
                            <td>1st Professional</td>
                            <td>Rachana Sharir</td>
                            <td>Theory + Practical + Dissection</td>
                        </tr>
                        <tr>
                            <td>BAMS</td>
                            <td>1st Professional</td>
                            <td>Osteology & Embryology</td>
                            <td>Practical</td>
                        </tr>
                        <tr>
                            <td>PG Workshops</td>
                            <td>Advanced</td>
                            <td>Applied Anatomy Training</td>
                            <td>Demonstration</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </section>


        <!-- ================= Faculty ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Faculty & Staff</h2>

            <div class="row g-4">

                <div class="col-md-4">
                    <div class="card text-center shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-bold">Dr. A. Kumar</h5>
                            <p class="text-muted mb-1">Professor & Head</p>
                            <small>MD (Sharir Rachana) | 16+ Years Experience</small>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="card text-center shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-bold">Dr. P. Singh</h5>
                            <p class="text-muted mb-1">Associate Professor</p>
                            <small>Anatomy & Dissection Specialist</small>
                        </div>
                    </div>
                </div>

            </div>
        </section>


        <!-- ================= Infrastructure ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Infrastructure & Facilities</h2>

            <div class="row row-cols-1 row-cols-md-2 g-2">
                <div class="col">✔ Well-equipped Dissection Hall</div>
                <div class="col">✔ Cadaver Preservation Unit</div>
                <div class="col">✔ Osteology Lab & Bone Sets</div>
                <div class="col">✔ Anatomy Museum with Models & Specimens</div>
                <div class="col">✔ Histology Slides & Microscopes</div>
                <div class="col">✔ Smart Classroom with AV System</div>
            </div>
        </section>


        <!-- ================= Teaching Methodology ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Teaching Methodology</h2>

            <ul>
                <li>Cadaveric dissection & live demonstrations</li>
                <li>Model-based anatomical teaching</li>
                <li>Interactive tutorials & seminars</li>
                <li>Case-oriented structural correlation</li>
                <li>Digital anatomy tools & visual aids</li>
            </ul>
        </section>


        <!-- ================= Research ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Research & Publications</h2>

            <ul>
                <li>Comparative studies in classical & modern anatomy</li>
                <li>Research on Sharir concepts</li>
                <li>Scientific publications & journals</li>
                <li>Conference presentations & academic papers</li>
            </ul>
        </section>


        <!-- ================= Activities ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Academic & Co-Curricular Activities</h2>

            <ul>
                <li>Anatomy exhibitions</li>
                <li>Dissection workshops</li>
                <li>Guest lectures by anatomy experts</li>
                <li>Student seminars & poster presentations</li>
            </ul>
        </section>


        <!-- ================= Student Support ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Student Support</h2>

            <ul>
                <li>Practical manuals & study notes</li>
                <li>Mentorship & academic counseling</li>
                <li>Internal assessments & feedback sessions</li>
                <li>Skill development programs</li>
            </ul>
        </section>


        <!-- ================= Gallery ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Photo & Media Gallery</h2>

            <div class="row g-3">
                <div class="col-md-3">
                    <img src="/images/rachana1.jpg" class="img-fluid rounded" alt="Dissection Hall">
                </div>
                <div class="col-md-3">
                    <img src="/images/rachana2.jpg" class="img-fluid rounded" alt="Anatomy Museum">
                </div>
                <div class="col-md-3">
                    <img src="/images/rachana3.jpg" class="img-fluid rounded" alt="Osteology Lab">
                </div>
                <div class="col-md-3">
                    <img src="/images/rachana4.jpg" class="img-fluid rounded" alt="Teaching Session">
                </div>
            </div>
        </section>

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\RKDF_New_Websites\new_rkcams.in\resources\views/Rachana-Sharira.blade.php ENDPATH**/ ?>