

<?php $__env->startSection('title', 'Department of Agada Tantra | Ayurvedic Toxicology and Forensic Medicine'); ?>
<?php $__env->startSection('meta_description',
    'Department of Agada Tantra offering Ayurvedic toxicology, forensic medicine, medico-legal
    studies, poison management, and emergency care training with modern laboratory and clinical exposure for BAMS
    students.'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Optional: Add your custom styles here -->
    <style>
        /* =========================
                GLOBAL STYLES
                ========================= */

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', 'Open Sans', Arial, sans-serif;
            font-size: 16px;
            line-height: 1.7;
            color: #333;
            background-color: #ffffff;
        }


        ul {
            list-style-image: url('bullet.png');
            /* Path to your bullet image */
            list-style-type: disc;
            /* Fallback if image is not available */
        }

        h1,
        h2,
        h3 {
            font-family: 'Poppins', 'Montserrat', sans-serif;
            color: #1f2a44;
            margin-bottom: 15px;
        }

        h1 {
            font-size: 36px;
        }

        h2 {
            font-size: 28px;
        }

        p {
            margin-bottom: 15px;
        }

        a {
            text-decoration: none;
            color: #1a4ed8;
        }

        a:hover {
            text-decoration: underline;
        }

        /* =========================
                                                            LAYOUT
                                                            ========================= */

        .container {
            max-width: 1100px;
            margin: auto;
            padding: 0 20px;
        }

        .section {
            padding: 60px 0;
        }

        .bg-light {
            background-color: #f7f9fc;
        }

        .bg-primary {
            background-color: #1f2a44;
        }

        /* =========================
                                                            HERO SECTION
                                                            ========================= */

        .hero-section {
            background: linear-gradient(rgba(31, 42, 68, 0.7),
                    rgba(31, 42, 68, 0.7)),
                url('campus-photo.jpg') center/cover no-repeat;
            text-align: center;
            padding: 100px 20px;
            color: #ffffff;
        }

        .hero-section h1 {
            color: #ffffff;
            font-size: 42px;
        }

        .hero-section p {
            font-size: 18px;
            margin-bottom: 30px;
        }

        /* =========================
                                                            BUTTONS
                                                            ========================= */

        .btn {
            display: inline-block;
            padding: 12px 26px;
            margin: 5px;
            border-radius: 6px;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .btn.primary {
            background-color: #f0b429;
            color: #1f2a44;
        }

        .btn.primary:hover {
            background-color: #d99b1f;
        }

        .btn.secondary {
            background-color: transparent;
            border: 2px solid #ffffff;
            color: #ffffff;
        }

        .btn.secondary:hover {
            background-color: #ffffff;
            color: #1f2a44;
        }

        /* =========================
                                                            LISTS & CONTENT
                                                            ========================= */

        .strength-list,
        .leadership-list,
        .important-links {
            list-style: none;
            padding-left: 0;
        }

        .strength-list li,
        .leadership-list li {
            padding: 10px 0;
            padding-left: 28px;
            position: relative;
        }

        .strength-list li::before {
            content: "✔";
            position: absolute;
            left: 0;
            color: #1a4ed8;
            font-weight: bold;
        }

        /* =========================
                                                            FACILITIES GRID
                                                            ========================= */

        .facility-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
            gap: 20px;
            margin-top: 30px;
        }

        .facility-item {
            background: #c9c7bf;
            padding: 25px;
            text-align: center;
            border-radius: 10px;
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.08);
            font-weight: 600;
        }

        /* =========================
                                                            LINKS SECTION
                                                            ========================= */

        .important-links li {
            margin-bottom: 10px;
        }

        .important-links a {
            color: #ffffff;
            font-weight: 500;
        }

        .section {
            padding: 30px 0;
        }

        /* =========================
                                                            FOOTER
                                                            ========================= */

        .footer {
            background-color: #f1f3f6;
            text-align: center;
            font-size: 14px;
            color: #666;
        }

        .footer p {
            margin: 0;
        }

        /* =========================
                                                            RESPONSIVE DESIGN
                                                            ========================= */

        @media (max-width: 768px) {
            h1 {
                font-size: 30px;
            }

            h2 {
                font-size: 24px;
            }

            .hero-section {
                padding: 70px 20px;
            }

            .btn {
                width: 100%;
                max-width: 280px;
            }
        }
    </style>
    <div class="container my-5">

        <!-- ================= PAGE HEADER ================= -->
        <header class="text-center mb-5">
            <h1 class="fw-bold">Department of Agada Tantra</h1>
            <p class="text-muted">
                Ayurvedic Toxicology • Poison Management • Forensic Medicine • Medical Jurisprudence
            </p>
        </header>


        <!-- ================= Department Overview ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Department Overview</h2>

            <p class="text-justify">
                The Department of Agada Tantra focuses on the principles of toxicology,
                poison identification, antidotal therapy, forensic medicine, and medico-legal
                practices. The department equips students with essential knowledge to manage
                poisoning emergencies, snake and insect bites, food toxicity, environmental hazards,
                and medico-legal cases. Training integrates classical Ayurvedic toxicology with modern
                forensic and emergency medical sciences to ensure safe and effective patient care.
            </p>

            <ul>
                <li>Study of natural, artificial, and environmental toxins</li>
                <li>Emergency management of poisoning cases</li>
                <li>Forensic medicine & medico-legal documentation</li>
                <li>Correlation of Ayurvedic and modern toxicology</li>
            </ul>
        </section>


        <!-- ================= Vision & Mission ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Vision & Mission</h2>

            <div class="row g-4">

                <div class="col-md-6">
                    <div class="card shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-semibold">Vision</h5>
                            <p>
                                To establish a center of excellence in Ayurvedic toxicology and forensic
                                sciences by delivering evidence-based training and ethical medico-legal practice.
                            </p>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="card shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-semibold">Mission</h5>
                            <ul>
                                <li>Provide clinical and laboratory exposure to toxicology</li>
                                <li>Develop emergency response competencies</li>
                                <li>Promote forensic research and documentation skills</li>
                                <li>Ensure safe and rational use of antidotes</li>
                            </ul>
                        </div>
                    </div>
                </div>

            </div>
        </section>


        <!-- ================= Courses ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Courses & Teaching Programs</h2>

            <div class="table-responsive">
                <table class="table table-bordered table-striped align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Program</th>
                            <th>Year</th>
                            <th>Subject</th>
                            <th>Component</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>BAMS</td>
                            <td>3rd Professional</td>
                            <td>Agada Tantra & Vyavahara Ayurveda</td>
                            <td>Theory + Practical</td>
                        </tr>
                        <tr>
                            <td>BAMS</td>
                            <td>3rd Professional</td>
                            <td>Forensic Medicine</td>
                            <td>Clinical Demonstration</td>
                        </tr>
                        <tr>
                            <td>Skill Training</td>
                            <td>Special Module</td>
                            <td>Emergency Poison Management</td>
                            <td>Hands-on</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </section>


        <!-- ================= Faculty ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Faculty & Staff</h2>

            <div class="row g-4">

                <div class="col-md-4">
                    <div class="card text-center shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-bold">Dr. M. Kulshreshtha</h5>
                            <p class="text-muted mb-1">Professor & Head</p>
                            <small>MD (Agada Tantra) | Toxicology Specialist</small>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="card text-center shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-bold">Dr. A. Nair</h5>
                            <p class="text-muted mb-1">Assistant Professor</p>
                            <small>Forensic Medicine & Legal Documentation Expert</small>
                        </div>
                    </div>
                </div>

            </div>
        </section>


        <!-- ================= Infrastructure ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Infrastructure & Facilities</h2>

            <div class="row row-cols-1 row-cols-md-2 g-2">
                <div class="col">✔ Toxicology Laboratory</div>
                <div class="col">✔ Forensic Demonstration Room</div>
                <div class="col">✔ Specimen & Poison Museum</div>
                <div class="col">✔ First Aid & Emergency Care Unit</div>
                <div class="col">✔ Audio-Visual Smart Classroom</div>
                <div class="col">✔ Clinical Training Support Facilities</div>
            </div>
        </section>


        <!-- ================= Teaching Methodology ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Teaching Methodology</h2>

            <ul>
                <li>Case-based learning and emergency simulations</li>
                <li>Laboratory experiments & poison identification</li>
                <li>Demonstration of medico-legal procedures</li>
                <li>Interactive lectures & seminars</li>
                <li>Field exposure to hospital emergency units</li>
            </ul>
        </section>


        <!-- ================= Research ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Research & Publications</h2>

            <ul>
                <li>Studies on antidotal therapies in Ayurveda</li>
                <li>Research on toxic plant and animal poisons</li>
                <li>Clinical data analysis on poisoning cases</li>
                <li>Peer-reviewed journal publications and presentations</li>
            </ul>
        </section>


        <!-- ================= Activities ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Academic & Co-Curricular Activities</h2>

            <ul>
                <li>Toxicology awareness programs</li>
                <li>First aid & emergency response workshops</li>
                <li>Guest lectures by forensic experts</li>
                <li>Student seminars & case discussions</li>
            </ul>
        </section>


        <!-- ================= Student Support ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Student Support</h2>

            <ul>
                <li>Practical manuals & toxicology charts</li>
                <li>Clinical case documentation training</li>
                <li>Mentorship & academic counseling</li>
                <li>Skill development in medico-legal reporting</li>
            </ul>
        </section>


        <!-- ================= Gallery ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Photo & Media Gallery</h2>

            <div class="row g-3">
                <div class="col-md-3">
                    <img src="/images/agada1.jpg" class="img-fluid rounded" alt="Toxicology Lab">
                </div>
                <div class="col-md-3">
                    <img src="/images/agada2.jpg" class="img-fluid rounded" alt="Forensic Demonstration">
                </div>
                <div class="col-md-3">
                    <img src="/images/agada3.jpg" class="img-fluid rounded" alt="Emergency Training">
                </div>
                <div class="col-md-3">
                    <img src="/images/agada4.jpg" class="img-fluid rounded" alt="Student Workshop">
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>





<?php $__env->startSection('title', 'Department of Agada Tantra | Ayurvedic Toxicology and Forensic Medicine'); ?>
<?php $__env->startSection('meta_description',
    'Department of Agada Tantra offering Ayurvedic toxicology, forensic medicine, medico-legal
    studies, poison management, and emergency care training with modern laboratory and clinical exposure for BAMS
    students.'); ?>

<?php $__env->startSection('content'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\RKDF_New_Websites\new_rkcams.in\resources\views/Agada-Tantra.blade.php ENDPATH**/ ?>