

<?php $__env->startSection('title', 'Department of Swasthavritta & Yoga | Ayurvedic Preventive Medicine and Lifestyle Sciences'); ?>
<?php $__env->startSection('meta_description', 'Department of Swasthavritta and Yoga offering preventive medicine, public health,
    lifestyle management, yoga therapy, naturopathy practices, and holistic wellness training for BAMS students and
    community health programs.'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Optional: Add your custom styles here -->
    <style>
        /* =========================
            GLOBAL STYLES
            ========================= */

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', 'Open Sans', Arial, sans-serif;
            font-size: 16px;
            line-height: 1.7;
            color: #333;
            background-color: #ffffff;
        }


        ul {
            list-style-image: url('bullet.png');
            /* Path to your bullet image */
            list-style-type: disc;
            /* Fallback if image is not available */
        }

        h1,
        h2,
        h3 {
            font-family: 'Poppins', 'Montserrat', sans-serif;
            color: #1f2a44;
            margin-bottom: 15px;
        }

        h1 {
            font-size: 36px;
        }

        h2 {
            font-size: 28px;
        }

        p {
            margin-bottom: 15px;
        }

        a {
            text-decoration: none;
            color: #1a4ed8;
        }

        a:hover {
            text-decoration: underline;
        }

        /* =========================
                                                        LAYOUT
                                                        ========================= */

        .container {
            max-width: 1100px;
            margin: auto;
            padding: 0 20px;
        }

        .section {
            padding: 60px 0;
        }

        .bg-light {
            background-color: #f7f9fc;
        }

        .bg-primary {
            background-color: #1f2a44;
        }

        /* =========================
                                                        HERO SECTION
                                                        ========================= */

        .hero-section {
            background: linear-gradient(rgba(31, 42, 68, 0.7),
                    rgba(31, 42, 68, 0.7)),
                url('campus-photo.jpg') center/cover no-repeat;
            text-align: center;
            padding: 100px 20px;
            color: #ffffff;
        }

        .hero-section h1 {
            color: #ffffff;
            font-size: 42px;
        }

        .hero-section p {
            font-size: 18px;
            margin-bottom: 30px;
        }

        /* =========================
                                                        BUTTONS
                                                        ========================= */

        .btn {
            display: inline-block;
            padding: 12px 26px;
            margin: 5px;
            border-radius: 6px;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .btn.primary {
            background-color: #f0b429;
            color: #1f2a44;
        }

        .btn.primary:hover {
            background-color: #d99b1f;
        }

        .btn.secondary {
            background-color: transparent;
            border: 2px solid #ffffff;
            color: #ffffff;
        }

        .btn.secondary:hover {
            background-color: #ffffff;
            color: #1f2a44;
        }

        /* =========================
                                                        LISTS & CONTENT
                                                        ========================= */

        .strength-list,
        .leadership-list,
        .important-links {
            list-style: none;
            padding-left: 0;
        }

        .strength-list li,
        .leadership-list li {
            padding: 10px 0;
            padding-left: 28px;
            position: relative;
        }

        .strength-list li::before {
            content: "✔";
            position: absolute;
            left: 0;
            color: #1a4ed8;
            font-weight: bold;
        }

        /* =========================
                                                        FACILITIES GRID
                                                        ========================= */

        .facility-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
            gap: 20px;
            margin-top: 30px;
        }

        .facility-item {
            background: #c9c7bf;
            padding: 25px;
            text-align: center;
            border-radius: 10px;
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.08);
            font-weight: 600;
        }

        /* =========================
                                                        LINKS SECTION
                                                        ========================= */

        .important-links li {
            margin-bottom: 10px;
        }

        .important-links a {
            color: #ffffff;
            font-weight: 500;
        }

        .section {
            padding: 30px 0;
        }

        /* =========================
                                                        FOOTER
                                                        ========================= */

        .footer {
            background-color: #f1f3f6;
            text-align: center;
            font-size: 14px;
            color: #666;
        }

        .footer p {
            margin: 0;
        }

        /* =========================
                                                        RESPONSIVE DESIGN
                                                        ========================= */

        @media (max-width: 768px) {
            h1 {
                font-size: 30px;
            }

            h2 {
                font-size: 24px;
            }

            .hero-section {
                padding: 70px 20px;
            }

            .btn {
                width: 100%;
                max-width: 280px;
            }
        }
    </style>
    <div class="container my-5">

        <!-- ================= PAGE HEADER ================= -->
        <header class="text-center mb-5">
            <h1 class="fw-bold">Department of Swasthavritta & Yoga</h1>
            <p class="text-muted">
                Preventive Healthcare • Public Health • Lifestyle Management • Yoga & Holistic Wellness
            </p>
        </header>


        <!-- ================= Department Overview ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Department Overview</h2>

            <p class="text-justify">
                The Department of Swasthavritta & Yoga focuses on preventive medicine, health promotion,
                and holistic living based on classical Ayurvedic principles. The department emphasizes
                daily and seasonal regimens, dietetics, mental wellbeing, yoga therapy, and public health
                practices to maintain physical, mental, and social harmony. Students are trained to apply
                lifestyle interventions and yoga-based therapies for disease prevention and long-term wellness.
            </p>

            <ul>
                <li>Preventive and promotive healthcare strategies</li>
                <li>Diet, lifestyle, and seasonal regimen planning</li>
                <li>Yoga therapy and stress management techniques</li>
                <li>Community health education and awareness programs</li>
            </ul>
        </section>


        <!-- ================= Vision & Mission ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Vision & Mission</h2>

            <div class="row g-4">

                <div class="col-md-6">
                    <div class="card shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-semibold">Vision</h5>
                            <p>
                                To establish a center of excellence in preventive healthcare and yoga sciences,
                                promoting healthy lifestyles and disease-free living through Ayurvedic wisdom.
                            </p>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="card shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-semibold">Mission</h5>
                            <ul>
                                <li>Promote preventive healthcare education</li>
                                <li>Encourage daily regimen and wellness practices</li>
                                <li>Provide yoga-based therapeutic training</li>
                                <li>Strengthen public health and community outreach</li>
                            </ul>
                        </div>
                    </div>
                </div>

            </div>
        </section>


        <!-- ================= Courses ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Courses & Teaching Programs</h2>

            <div class="table-responsive">
                <table class="table table-bordered table-striped align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Program</th>
                            <th>Year</th>
                            <th>Subject</th>
                            <th>Component</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>BAMS</td>
                            <td>3rd Professional</td>
                            <td>Swasthavritta & Yoga</td>
                            <td>Theory + Practical</td>
                        </tr>
                        <tr>
                            <td>BAMS</td>
                            <td>3rd Professional</td>
                            <td>Yoga Therapy & Lifestyle Management</td>
                            <td>Clinical Practice</td>
                        </tr>
                        <tr>
                            <td>Community Programs</td>
                            <td>Special Module</td>
                            <td>Public Health & Wellness Camps</td>
                            <td>Field Training</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </section>


        <!-- ================= Faculty ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Faculty & Staff</h2>

            <div class="row g-4">

                <div class="col-md-4">
                    <div class="card text-center shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-bold">Dr. P. Tripathi</h5>
                            <p class="text-muted mb-1">Professor & Head</p>
                            <small>MD (Swasthavritta) | Preventive Medicine Specialist</small>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="card text-center shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-bold">Dr. R. Joshi</h5>
                            <p class="text-muted mb-1">Assistant Professor</p>
                            <small>Yoga Therapy & Lifestyle Consultant</small>
                        </div>
                    </div>
                </div>

            </div>
        </section>


        <!-- ================= Infrastructure ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Infrastructure & Facilities</h2>

            <div class="row row-cols-1 row-cols-md-2 g-2">
                <div class="col">✔ Yoga Hall & Meditation Center</div>
                <div class="col">✔ Demonstration Room for Lifestyle Practices</div>
                <div class="col">✔ Community Health Training Unit</div>
                <div class="col">✔ Dietetics & Nutrition Lab</div>
                <div class="col">✔ Audio-Visual Smart Classroom</div>
                <div class="col">✔ Health Education Resource Library</div>
            </div>
        </section>


        <!-- ================= Teaching Methodology ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Teaching Methodology</h2>

            <ul>
                <li>Interactive lectures and demonstrations</li>
                <li>Yoga practice sessions & meditation training</li>
                <li>Case-based lifestyle counseling</li>
                <li>Community health outreach activities</li>
                <li>Workshops and wellness camps</li>
            </ul>
        </section>


        <!-- ================= Research ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Research & Publications</h2>

            <ul>
                <li>Studies on preventive healthcare models</li>
                <li>Research in yoga therapy and stress management</li>
                <li>Public health intervention projects</li>
                <li>Peer-reviewed publications & conference papers</li>
            </ul>
        </section>


        <!-- ================= Activities ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Academic & Co-Curricular Activities</h2>

            <ul>
                <li>International Yoga Day celebrations</li>
                <li>Health awareness rallies</li>
                <li>Community wellness camps</li>
                <li>Guest lectures and seminars</li>
            </ul>
        </section>


        <!-- ================= Student Support ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Student Support</h2>

            <ul>
                <li>Yoga manuals & training guides</li>
                <li>Diet and lifestyle counseling resources</li>
                <li>Mentorship and academic guidance</li>
                <li>Internship opportunities in wellness programs</li>
            </ul>
        </section>


        <!-- ================= Gallery ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Photo & Media Gallery</h2>

            <div class="row g-3">
                <div class="col-md-3">
                    <img src="/images/yoga1.jpg" class="img-fluid rounded" alt="Yoga Practice Session">
                </div>
                <div class="col-md-3">
                    <img src="/images/yoga2.jpg" class="img-fluid rounded" alt="Meditation Hall">
                </div>
                <div class="col-md-3">
                    <img src="/images/yoga3.jpg" class="img-fluid rounded" alt="Health Camp Activity">
                </div>
                <div class="col-md-3">
                    <img src="/images/yoga4.jpg" class="img-fluid rounded" alt="Community Wellness Program">
                </div>
            </div>
        </section>

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\RKDF_New_Websites\new_rkcams.in\resources\views/Swasthavritta-Yoga.blade.php ENDPATH**/ ?>