

<?php $__env->startSection('title', 'Department of Sanskrit Samhita & Siddhanta - RKCAMS.IN'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Optional: Add your custom styles here -->
    <style>
        /* =========================
        GLOBAL STYLES
        ========================= */

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', 'Open Sans', Arial, sans-serif;
            font-size: 16px;
            line-height: 1.7;
            color: #333;
            background-color: #ffffff;
        }


        ul {
            list-style-image: url('bullet.png');
            /* Path to your bullet image */
            list-style-type: disc;
            /* Fallback if image is not available */
        }

        h1,
        h2,
        h3 {
            font-family: 'Poppins', 'Montserrat', sans-serif;
            color: #1f2a44;
            margin-bottom: 15px;
        }

        h1 {
            font-size: 36px;
        }

        h2 {
            font-size: 28px;
        }

        p {
            margin-bottom: 15px;
        }

        a {
            text-decoration: none;
            color: #1a4ed8;
        }

        a:hover {
            text-decoration: underline;
        }

        /* =========================
                                                    LAYOUT
                                                    ========================= */

        .container {
            max-width: 1100px;
            margin: auto;
            padding: 0 20px;
        }

        .section {
            padding: 60px 0;
        }

        .bg-light {
            background-color: #f7f9fc;
        }

        .bg-primary {
            background-color: #1f2a44;
        }

        /* =========================
                                                    HERO SECTION
                                                    ========================= */

        .hero-section {
            background: linear-gradient(rgba(31, 42, 68, 0.7),
                    rgba(31, 42, 68, 0.7)),
                url('campus-photo.jpg') center/cover no-repeat;
            text-align: center;
            padding: 100px 20px;
            color: #ffffff;
        }

        .hero-section h1 {
            color: #ffffff;
            font-size: 42px;
        }

        .hero-section p {
            font-size: 18px;
            margin-bottom: 30px;
        }

        /* =========================
                                                    BUTTONS
                                                    ========================= */

        .btn {
            display: inline-block;
            padding: 12px 26px;
            margin: 5px;
            border-radius: 6px;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .btn.primary {
            background-color: #f0b429;
            color: #1f2a44;
        }

        .btn.primary:hover {
            background-color: #d99b1f;
        }

        .btn.secondary {
            background-color: transparent;
            border: 2px solid #ffffff;
            color: #ffffff;
        }

        .btn.secondary:hover {
            background-color: #ffffff;
            color: #1f2a44;
        }

        /* =========================
                                                    LISTS & CONTENT
                                                    ========================= */

        .strength-list,
        .leadership-list,
        .important-links {
            list-style: none;
            padding-left: 0;
        }

        .strength-list li,
        .leadership-list li {
            padding: 10px 0;
            padding-left: 28px;
            position: relative;
        }

        .strength-list li::before {
            content: "✔";
            position: absolute;
            left: 0;
            color: #1a4ed8;
            font-weight: bold;
        }

        /* =========================
                                                    FACILITIES GRID
                                                    ========================= */

        .facility-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
            gap: 20px;
            margin-top: 30px;
        }

        .facility-item {
            background: #c9c7bf;
            padding: 25px;
            text-align: center;
            border-radius: 10px;
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.08);
            font-weight: 600;
        }

        /* =========================
                                                    LINKS SECTION
                                                    ========================= */

        .important-links li {
            margin-bottom: 10px;
        }

        .important-links a {
            color: #ffffff;
            font-weight: 500;
        }

        .section {
            padding: 30px 0;
        }

        /* =========================
                                                    FOOTER
                                                    ========================= */

        .footer {
            background-color: #f1f3f6;
            text-align: center;
            font-size: 14px;
            color: #666;
        }

        .footer p {
            margin: 0;
        }

        /* =========================
                                                    RESPONSIVE DESIGN
                                                    ========================= */

        @media (max-width: 768px) {
            h1 {
                font-size: 30px;
            }

            h2 {
                font-size: 24px;
            }

            .hero-section {
                padding: 70px 20px;
            }

            .btn {
                width: 100%;
                max-width: 280px;
            }
        }
    </style>
    <div class="container my-5">

        <!-- Page Header -->
        <header class="text-center mb-5">
            <h1 class="fw-bold">Department of Sanskrit Samhita & Siddhanta</h1>
            <p class="text-muted">
                Foundation of Ayurvedic Principles, Classical Texts & Sanskrit Studies
            </p>
        </header>


        <!-- ================= Department Overview ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Department Overview</h2>

            <p class="text-justify">
                The department focuses on Sanskrit language, classical Ayurvedic texts,
                and fundamental principles that form the theoretical base of Ayurveda.
                Students gain strong conceptual clarity of Dosha–Dhatu–Mala Siddhanta,
                Samhita interpretation, and Ayurvedic philosophy.
            </p>

            <ul>
                <li>Classical Samhita studies</li>
                <li>Sanskrit grammar & terminology</li>
                <li>Ayurveda philosophy (Padartha Vigyan)</li>
                <li>Conceptual foundation for clinical subjects</li>
            </ul>
        </section>


        <!-- ================= Vision & Mission ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Vision & Mission</h2>

            <div class="row g-4">
                <div class="col-md-6">
                    <div class="card shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-semibold">Vision</h5>
                            <p>
                                To preserve and propagate authentic Ayurvedic knowledge
                                through classical texts and evidence-based teaching.
                            </p>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="card shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-semibold">Mission</h5>
                            <ul>
                                <li>Promote Sanskrit proficiency</li>
                                <li>Strengthen theoretical clarity</li>
                                <li>Encourage textual research</li>
                                <li>Integrate modern teaching tools</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>


        <!-- ================= Courses ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Courses & Teaching Programs</h2>

            <div class="table-responsive">
                <table class="table table-bordered table-striped">
                    <thead class="table-light">
                        <tr>
                            <th>Program</th>
                            <th>Year</th>
                            <th>Subject</th>
                            <th>Nature</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>BAMS</td>
                            <td>1st Professional</td>
                            <td>Sanskrit</td>
                            <td>Theory</td>
                        </tr>
                        <tr>
                            <td>BAMS</td>
                            <td>1st Professional</td>
                            <td>Padartha Vigyan</td>
                            <td>Theory</td>
                        </tr>
                        <tr>
                            <td>BAMS</td>
                            <td>1st Professional</td>
                            <td>Ayurveda Itihasa</td>
                            <td>Theory</td>
                        </tr>
                        <tr>
                            <td>MD</td>
                            <td>PG</td>
                            <td>Samhita Siddhanta</td>
                            <td>Research</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </section>


        <!-- ================= Faculty ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Faculty & Staff</h2>

            <div class="row g-4">

                <div class="col-md-4">
                    <div class="card shadow-sm text-center">
                        <div class="card-body">
                            <h5 class="fw-bold">Dr. ABC Sharma</h5>
                            <p class="text-muted">Professor & HOD</p>
                            <small>MD (Samhita) | 15+ Years Experience</small>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="card shadow-sm text-center">
                        <div class="card-body">
                            <h5 class="fw-bold">Dr. XYZ Verma</h5>
                            <p class="text-muted">Associate Professor</p>
                            <small>MD | Sanskrit Specialist</small>
                        </div>
                    </div>
                </div>

            </div>
        </section>


        <!-- ================= Infrastructure ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Infrastructure & Facilities</h2>

            <ul class="row row-cols-1 row-cols-md-2 g-2">
                <li class="col">Smart Classrooms</li>
                <li class="col">Seminar Hall</li>
                <li class="col">Digital Library</li>
                <li class="col">Reference Text Collection</li>
                <li class="col">Sanskrit Language Lab</li>
                <li class="col">Audio-Visual Teaching Aids</li>
            </ul>
        </section>


        <!-- ================= Teaching Methodology ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Teaching Methodology</h2>

            <ul>
                <li>Shloka recitation & interpretation</li>
                <li>Concept-based learning</li>
                <li>Seminars & presentations</li>
                <li>Interactive classroom discussions</li>
                <li>E-learning & smart boards</li>
            </ul>
        </section>


        <!-- ================= Research ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Research & Publications</h2>

            <ul>
                <li>Textual interpretation research</li>
                <li>Classical manuscript translation</li>
                <li>Conference presentations</li>
                <li>Peer-reviewed publications</li>
            </ul>
        </section>


        <!-- ================= Activities ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Academic & Co-Curricular Activities</h2>

            <ul>
                <li>Sanskrit workshops</li>
                <li>Guest lectures</li>
                <li>Ayurveda Day celebrations</li>
                <li>Student seminars</li>
            </ul>
        </section>


        <!-- ================= Student Support ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Student Support</h2>

            <ul>
                <li>Study materials & notes</li>
                <li>Mentorship program</li>
                <li>Doubt clearing sessions</li>
                <li>Internal assessment guidance</li>
            </ul>
        </section>


        <!-- ================= Gallery ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Photo & Media Gallery</h2>

            <div class="row g-3">
                <div class="col-md-3"><img src="/images/department1.jpg" class="img-fluid rounded" alt=""></div>
                <div class="col-md-3"><img src="/images/department2.jpg" class="img-fluid rounded" alt=""></div>
                <div class="col-md-3"><img src="/images/department3.jpg" class="img-fluid rounded" alt=""></div>
                <div class="col-md-3"><img src="/images/department4.jpg" class="img-fluid rounded" alt=""></div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\RKDF_New_Websites\new_rkcams.in\resources\views/Samhita-Siddhanta-Sanskrit.blade.php ENDPATH**/ ?>