@extends('layouts.admin')

@section('content')
    <div class="d-flex justify-content-between mb-3">
        <h4>Stats Management</h4>
        <a href="{{ route('admin.stats.create') }}" class="btn btn-primary">+ Add</a>
    </div>

    <table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>#</th>
                <th>Title</th>
                <th>Count</th>
                <th>Status</th>
                <th width="180">Action</th>
            </tr>
        </thead>

        <tbody>
            @foreach ($stats as $stat)
                <tr>
                    <td>{{ $stat->id }}</td>
                    <td>{{ $stat->title }}</td>
                    <td>{{ number_format($stat->count) }}</td>
                    <td>{{ $stat->is_active ? 'Active' : 'Inactive' }}</td>
                    <td>
                        <a class="btn btn-sm btn-info" href="{{ route('admin.stats.show', $stat) }}">View</a>
                        <a class="btn btn-sm btn-warning" href="{{ route('admin.stats.edit', $stat) }}">Edit</a>

                        <form method="POST" action="{{ route('admin.stats.destroy', $stat) }}" class="d-inline">
                            @csrf @method('DELETE')
                            <button class="btn btn-sm btn-danger">Delete</button>
                        </form>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>

    {{ $stats->links() }}
    <link href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
@endsection
