@extends('layouts.admin')

@section('content')
    <div class="mb-3">
        <label>Title</label>
        <input name="title" value="{{ old('title', $stat->title ?? '') }}" class="form-control" required>
    </div>

    <div class="mb-3">
        <label>Slug</label>
        <input name="slug" value="{{ old('slug', $stat->slug ?? '') }}" class="form-control" required>
    </div>

    <div class="mb-3">
        <label>Count</label>
        <input type="number" name="count" value="{{ old('count', $stat->count ?? 0) }}" class="form-control">
    </div>

    <div class="mb-3">
        <label>Color</label>
        <select name="color" class="form-select">
            <option value="success">Green</option>
            <option value="primary">Blue</option>
            <option value="warning">Yellow</option>
            <option value="danger">Red</option>
        </select>
    </div>

    <div class="form-check mb-3">
        <input type="checkbox" name="is_active" value="1" class="form-check-input"
            {{ old('is_active', $stat->is_active ?? true) ? 'checked' : '' }}>
        <label class="form-check-label">Active</label>
    </div>
@endsection