@extends('layouts.app')

@section('title', 'Home Page - RKCAMS.IN')

@section('content')
    @if(session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

<form method="POST" action="{{ route('enquiry.store') }}" class="card shadow-sm p-4">
    @csrf

    <h4 class="text-center mb-4">Send Us Your Enquiry</h4>

    <div class="mb-3">
        <label class="form-label">Full Name</label>
        <input type="text" name="name" class="form-control" maxlength="100" required value="{{ old('name') }}">
        @error('name') <small class="text-danger">{{ $message }}</small> @enderror
    </div>

    <div class="mb-3">
        <label class="form-label">Email ID</label>
        <input type="email" name="email" class="form-control" maxlength="150" required value="{{ old('email') }}">
        @error('email') <small class="text-danger">{{ $message }}</small> @enderror
    </div>

    <div class="mb-3">
        <label class="form-label">Mobile Number</label>
        <input type="tel" name="mobile" class="form-control" pattern="[6-9][0-9]{9}"
            placeholder="10-digit mobile number" required value="{{ old('mobile') }}">
        @error('mobile') <small class="text-danger">{{ $message }}</small> @enderror
    </div>

    <div class="mb-3">
        <label class="form-label">Your Query</label>
        <textarea name="message" class="form-control" rows="4" maxlength="1000" required>{{ old('message') }}</textarea>
        @error('message') <small class="text-danger">{{ $message }}</small> @enderror
    </div>

    <button type="submit" class="btn btn-primary w-100">
        Submit Enquiry
    </button>

    <p class="text-muted text-center mt-3 small">
        Our admission team will contact you within 24 working hours.
    </p>
</form>
@endsection