@extends('layouts.app')

@section('title', 'CME Page - RKCAMS.IN')

@section('content')
<section class="cme-section py-5">
    <div class="container">

        <!-- Page Header -->
        <div class="text-center mb-5">
            <h2 class="fw-bold">CME Programmes</h2>
            <p class="text-muted">
                Ram Krishna College of Ayurveda &amp; Medical Sciences, RKDF University – Bhopal
            </p>
        </div>

        <!-- Intro Text -->
        <div class="mb-4">
            <p>
                The college regularly organizes Continuing Medical Education (CME) programmes,
                seminars, workshops, and academic activities to enhance professional competence
                and academic excellence among faculty and students.
            </p>
        </div>

        <!-- CME IMAGE GALLERY -->
        <div class="row g-4 mb-5">
            <!-- CME Image 1 -->
            <div class="col-lg-3 col-md-4 col-sm-6">
                <div class="card h-100 shadow-sm">
                    <img src="{{ asset('images\cme\1.png') }}" class="card-img-top img-fluid" alt="CME Programme 1">
                    <div class="card-body text-center p-2">
                        <small class="text-muted">CME Programme</small>
                    </div>
                </div>
            </div>

            <!-- CME Image 2 -->
            <div class="col-lg-3 col-md-4 col-sm-6">
                <div class="card h-100 shadow-sm">
                    <img src="{{ asset('images\cme\2.png') }}" class="card-img-top img-fluid" alt="CME Programme 2">
                    <div class="card-body text-center p-2">
                        <small class="text-muted">Workshop Session</small>
                    </div>
                </div>
            </div>

            <!-- CME Image 3 -->
            <div class="col-lg-3 col-md-4 col-sm-6">
                <div class="card h-100 shadow-sm">
                    <img src="{{ asset('images\cme\3.png') }}" class="card-img-top img-fluid" alt="CME Programme 3">
                    <div class="card-body text-center p-2">
                        <small class="text-muted">Seminar on Ayurveda</small>
                    </div>
                    <img src="{{ asset('images\cme\4.png') }}" class="card-img-top img-fluid" alt="CME Programme 3">
                    <div class="card-body text-center p-2">
                        <small class="text-muted">Seminar on Ayurveda</small>
                    </div>
                </div>
            </div>

            <!-- CME Image 4 -->
            <div class="col-lg-3 col-md-4 col-sm-6">
                <div class="card h-100 shadow-sm">
                    <img src="{{ asset('images/cme/5.png') }}" class="card-img-top img-fluid" alt="CME Programme 4">
                    <div class="card-body text-center p-2">
                        <small class="text-muted">Guest Lecture</small>
                    </div>
                </div>
            </div>
        </div>

        <div class="row g-4 mb-5">
            <!-- CME Image 5 -->
            <div class="col-lg-3 col-md-4 col-sm-6">
                <div class="card h-100 shadow-sm">
                    <img src="{{ asset('images\cme\6.png') }}" class="card-img-top img-fluid" alt="CME Programme 1">
                    <div class="card-body text-center p-2">
                        <small class="text-muted">CME Programme</small>
                    </div>
                    <img src="{{ asset('images\cme\7.png') }}" class="card-img-top img-fluid" alt="CME Programme 2">
                    <div class="card-body text-center p-2">
                        <small class="text-muted">Workshop Session</small>
                    </div>
                </div>
            </div>

            <!-- CME Image 2 -->
            <div class="col-lg-3 col-md-4 col-sm-6">
                <div class="card h-100 shadow-sm">
                    <img src="{{ asset('images\cme\8.png') }}" class="card-img-top img-fluid" alt="CME Programme 2">
                    <div class="card-body text-center p-2">
                        <small class="text-muted">Workshop Session</small>
                    </div>
                    <img src="{{ asset('images\cme\9.png') }}" class="card-img-top img-fluid" alt="CME Programme 2">
                    <div class="card-body text-center p-2">
                        <small class="text-muted">Workshop Session</small>
                    </div>
                </div>
            </div>

            <!-- CME Image 3 -->
            <div class="col-lg-3 col-md-4 col-sm-6">
                <div class="card h-100 shadow-sm">
                    <img src="{{ asset('images\cme\10.png') }}" class="card-img-top img-fluid" alt="CME Programme 3">
                    <div class="card-body text-center p-2">
                        <small class="text-muted">Seminar on Ayurveda</small>
                    </div>
                    <img src="{{ asset('images\cme\11.png') }}" class="card-img-top img-fluid" alt="CME Programme 3">
                    <div class="card-body text-center p-2">
                        <small class="text-muted">Seminar on Ayurveda</small>
                    </div>
                </div>
            </div>

            <!-- CME Image 4 -->
            <div class="col-lg-3 col-md-4 col-sm-6">
                <div class="card h-100 shadow-sm">
                    <img src="{{ asset('images/cme/12.png') }}" class="card-img-top img-fluid" alt="CME Programme 4">
                    <div class="card-body text-center p-2">
                        <small class="text-muted">Guest Lecture</small>
                    </div>
                    <img src="{{ asset('images/cme/13.png') }}" class="card-img-top img-fluid" alt="CME Programme 4">
                    <div class="card-body text-center p-2">
                        <small class="text-muted">Guest Lecture</small>
                    </div>
                </div>
            </div>

            <!-- Add more images by duplicating col-* block -->
        </div>

        <!-- Academic Strength -->
        <div class="mb-4">
            <h4 class="fw-bold">Academic Strength</h4>
            <p class="text-muted">
                CME programmes strengthen academic learning by providing exposure to
                recent advancements, clinical practices, and interdisciplinary discussions.
            </p>
        </div>

        <!-- Important Links -->
        <div class="mb-5">
            <h4 class="fw-bold">Important Links</h4>
            <ul class="list-group list-group-flush">
                <li class="list-group-item">
                    <a href="https://rkdf.ac.in" target="_blank">RKDF University</a>
                </li>
                <li class="list-group-item">
                    <a href="https://ncismindia.org" target="_blank">
                        National Commission for Indian System of Medicine (NCISM)
                    </a>
                </li>
                <li class="list-group-item">
                    <a href="https://www.ayush.gov.in" target="_blank">
                        Ministry of AYUSH
                    </a>
                </li>
                <li class="list-group-item">
                    <a href="https://ayush.mp.gov.in/" target="_blank">
                        AYUSH Department, M.P
                    </a>
                </li>                
            </ul>
        </div>
    </div>
</section>
@endsection