@extends('layouts.app')

@section('title', 'Department of Roga Nidan & Vikriti Vigyan | Ayurvedic Pathology and Diagnostic Sciences')
@section('meta_description',
    'Department of Roga Nidan and Vikriti Vigyan providing Ayurvedic pathology, diagnostic
    techniques, clinical laboratory training, disease investigation, and modern diagnostic correlation for BAMS students.')

@section('content')
    <!-- Optional: Add your custom styles here -->
    <style>
        /* =========================
                GLOBAL STYLES
                ========================= */

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', 'Open Sans', Arial, sans-serif;
            font-size: 16px;
            line-height: 1.7;
            color: #333;
            background-color: #ffffff;
        }


        ul {
            list-style-image: url('bullet.png');
            /* Path to your bullet image */
            list-style-type: disc;
            /* Fallback if image is not available */
        }

        h1,
        h2,
        h3 {
            font-family: 'Poppins', 'Montserrat', sans-serif;
            color: #1f2a44;
            margin-bottom: 15px;
        }

        h1 {
            font-size: 36px;
        }

        h2 {
            font-size: 28px;
        }

        p {
            margin-bottom: 15px;
        }

        a {
            text-decoration: none;
            color: #1a4ed8;
        }

        a:hover {
            text-decoration: underline;
        }

        /* =========================
                                                            LAYOUT
                                                            ========================= */

        .container {
            max-width: 1100px;
            margin: auto;
            padding: 0 20px;
        }

        .section {
            padding: 60px 0;
        }

        .bg-light {
            background-color: #f7f9fc;
        }

        .bg-primary {
            background-color: #1f2a44;
        }

        /* =========================
                                                            HERO SECTION
                                                            ========================= */

        .hero-section {
            background: linear-gradient(rgba(31, 42, 68, 0.7),
                    rgba(31, 42, 68, 0.7)),
                url('campus-photo.jpg') center/cover no-repeat;
            text-align: center;
            padding: 100px 20px;
            color: #ffffff;
        }

        .hero-section h1 {
            color: #ffffff;
            font-size: 42px;
        }

        .hero-section p {
            font-size: 18px;
            margin-bottom: 30px;
        }

        /* =========================
                                                            BUTTONS
                                                            ========================= */

        .btn {
            display: inline-block;
            padding: 12px 26px;
            margin: 5px;
            border-radius: 6px;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .btn.primary {
            background-color: #f0b429;
            color: #1f2a44;
        }

        .btn.primary:hover {
            background-color: #d99b1f;
        }

        .btn.secondary {
            background-color: transparent;
            border: 2px solid #ffffff;
            color: #ffffff;
        }

        .btn.secondary:hover {
            background-color: #ffffff;
            color: #1f2a44;
        }

        /* =========================
                                                            LISTS & CONTENT
                                                            ========================= */

        .strength-list,
        .leadership-list,
        .important-links {
            list-style: none;
            padding-left: 0;
        }

        .strength-list li,
        .leadership-list li {
            padding: 10px 0;
            padding-left: 28px;
            position: relative;
        }

        .strength-list li::before {
            content: "✔";
            position: absolute;
            left: 0;
            color: #1a4ed8;
            font-weight: bold;
        }

        /* =========================
                                                            FACILITIES GRID
                                                            ========================= */

        .facility-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
            gap: 20px;
            margin-top: 30px;
        }

        .facility-item {
            background: #c9c7bf;
            padding: 25px;
            text-align: center;
            border-radius: 10px;
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.08);
            font-weight: 600;
        }

        /* =========================
                                                            LINKS SECTION
                                                            ========================= */

        .important-links li {
            margin-bottom: 10px;
        }

        .important-links a {
            color: #ffffff;
            font-weight: 500;
        }

        .section {
            padding: 30px 0;
        }

        /* =========================
                                                            FOOTER
                                                            ========================= */

        .footer {
            background-color: #f1f3f6;
            text-align: center;
            font-size: 14px;
            color: #666;
        }

        .footer p {
            margin: 0;
        }

        /* =========================
                                                            RESPONSIVE DESIGN
                                                            ========================= */

        @media (max-width: 768px) {
            h1 {
                font-size: 30px;
            }

            h2 {
                font-size: 24px;
            }

            .hero-section {
                padding: 70px 20px;
            }

            .btn {
                width: 100%;
                max-width: 280px;
            }
        }
    </style>
    <div class="container my-5">

        <!-- ================= PAGE HEADER ================= -->
        <header class="text-center mb-5">
            <h1 class="fw-bold">Department of Roga Nidan & Vikriti Vigyan</h1>
            <p class="text-muted">
                Ayurvedic Pathology • Diagnostic Sciences • Disease Investigation • Clinical Laboratory Training
            </p>
        </header>


        <!-- ================= Department Overview ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Department Overview</h2>

            <p class="text-justify">
                The Department of Roga Nidan & Vikriti Vigyan specializes in the scientific understanding
                of disease causation, pathogenesis, diagnostic evaluation, and clinical investigation.
                Students are trained to assess disease conditions through classical Ayurvedic methods such
                as Dashavidha Pariksha, Ashtavidha Pariksha, and Nadi Pariksha, along with modern
                laboratory investigations. The department builds diagnostic competence essential for
                accurate clinical decision-making and patient care.
            </p>

            <ul>
                <li>Study of disease etiology and pathology</li>
                <li>Clinical diagnostic methods in Ayurveda</li>
                <li>Laboratory-based investigations</li>
                <li>Integration of traditional and modern diagnostics</li>
            </ul>
        </section>


        <!-- ================= Vision & Mission ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Vision & Mission</h2>

            <div class="row g-4">

                <div class="col-md-6">
                    <div class="card shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-semibold">Vision</h5>
                            <p>
                                To develop excellence in Ayurvedic diagnostic sciences through evidence-based
                                pathology training and modern investigative support systems.
                            </p>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="card shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-semibold">Mission</h5>
                            <ul>
                                <li>Strengthen clinical diagnostic skills</li>
                                <li>Provide hands-on laboratory training</li>
                                <li>Promote research in pathology and disease mechanisms</li>
                                <li>Integrate classical diagnostic wisdom with technology</li>
                            </ul>
                        </div>
                    </div>
                </div>

            </div>
        </section>


        <!-- ================= Courses ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Courses & Teaching Programs</h2>

            <div class="table-responsive">
                <table class="table table-bordered table-striped align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Program</th>
                            <th>Year</th>
                            <th>Subject</th>
                            <th>Component</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>BAMS</td>
                            <td>2nd Professional</td>
                            <td>Roga Nidan & Vikriti Vigyan</td>
                            <td>Theory + Practical</td>
                        </tr>
                        <tr>
                            <td>BAMS</td>
                            <td>2nd Professional</td>
                            <td>Clinical Pathology</td>
                            <td>Laboratory Training</td>
                        </tr>
                        <tr>
                            <td>Workshops</td>
                            <td>Advanced</td>
                            <td>Diagnostic Techniques & Case Analysis</td>
                            <td>Hands-on</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </section>


        <!-- ================= Faculty ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Faculty & Staff</h2>

            <div class="row g-4">

                <div class="col-md-4">
                    <div class="card text-center shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-bold">Dr. S. Patil</h5>
                            <p class="text-muted mb-1">Professor & Head</p>
                            <small>MD (Roga Nidan) | Diagnostic Specialist</small>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="card text-center shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-bold">Dr. K. Verma</h5>
                            <p class="text-muted mb-1">Assistant Professor</p>
                            <small>Clinical Pathology & Laboratory Medicine</small>
                        </div>
                    </div>
                </div>

            </div>
        </section>


        <!-- ================= Infrastructure ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Infrastructure & Facilities</h2>

            <div class="row row-cols-1 row-cols-md-2 g-2">
                <div class="col">✔ Clinical Pathology Laboratory</div>
                <div class="col">✔ Hematology & Biochemistry Lab</div>
                <div class="col">✔ Microscopy & Diagnostic Equipment</div>
                <div class="col">✔ Specimen Collection Unit</div>
                <div class="col">✔ Demonstration Hall</div>
                <div class="col">✔ Smart Classroom with Audio-Visual Tools</div>
            </div>
        </section>


        <!-- ================= Teaching Methodology ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Teaching Methodology</h2>

            <ul>
                <li>Case-based diagnostic learning</li>
                <li>Hands-on laboratory experiments</li>
                <li>Clinical demonstrations & patient evaluation</li>
                <li>Interactive tutorials and seminars</li>
                <li>Correlation of classical and modern pathology concepts</li>
            </ul>
        </section>


        <!-- ================= Research ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Research & Publications</h2>

            <ul>
                <li>Studies on disease mechanisms in Ayurveda</li>
                <li>Diagnostic protocol standardization</li>
                <li>Clinical data analysis projects</li>
                <li>Peer-reviewed journal publications</li>
            </ul>
        </section>


        <!-- ================= Activities ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Academic & Co-Curricular Activities</h2>

            <ul>
                <li>Diagnostic workshops</li>
                <li>Health screening camps</li>
                <li>Student seminars & case presentations</li>
                <li>Guest lectures by pathology experts</li>
            </ul>
        </section>


        <!-- ================= Student Support ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Student Support</h2>

            <ul>
                <li>Practical manuals & case sheets</li>
                <li>Diagnostic record books</li>
                <li>Mentorship and academic guidance</li>
                <li>Skill development training sessions</li>
            </ul>
        </section>


        <!-- ================= Gallery ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Photo & Media Gallery</h2>

            <div class="row g-3">
                <div class="col-md-3">
                    <img src="/images/roga1.jpg" class="img-fluid rounded" alt="Pathology Laboratory">
                </div>
                <div class="col-md-3">
                    <img src="/images/roga2.jpg" class="img-fluid rounded" alt="Diagnostic Equipment">
                </div>
                <div class="col-md-3">
                    <img src="/images/roga3.jpg" class="img-fluid rounded" alt="Clinical Demonstration">
                </div>
                <div class="col-md-3">
                    <img src="/images/roga4.jpg" class="img-fluid rounded" alt="Student Training Session">
                </div>
            </div>
        </section>

    </div>
@endsection
