@extends('layouts.app')

@section('title', 'Department of Panchakarma | Ayurvedic Detoxification and Rejuvenation Therapies')
@section('meta_description',
    'Department of Panchakarma providing Ayurvedic detoxification, Shodhana therapies, OPD/IPD
    Panchakarma treatments, rejuvenation care, and hands-on clinical training with modern therapy units and hospital
    facilities.')

@section('content')
    <!-- Optional: Add your custom styles here -->
    <style>
        /* =========================
                GLOBAL STYLES
                ========================= */

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', 'Open Sans', Arial, sans-serif;
            font-size: 16px;
            line-height: 1.7;
            color: #333;
            background-color: #ffffff;
        }


        ul {
            list-style-image: url('bullet.png');
            /* Path to your bullet image */
            list-style-type: disc;
            /* Fallback if image is not available */
        }

        h1,
        h2,
        h3 {
            font-family: 'Poppins', 'Montserrat', sans-serif;
            color: #1f2a44;
            margin-bottom: 15px;
        }

        h1 {
            font-size: 36px;
        }

        h2 {
            font-size: 28px;
        }

        p {
            margin-bottom: 15px;
        }

        a {
            text-decoration: none;
            color: #1a4ed8;
        }

        a:hover {
            text-decoration: underline;
        }

        /* =========================
                                                            LAYOUT
                                                            ========================= */

        .container {
            max-width: 1100px;
            margin: auto;
            padding: 0 20px;
        }

        .section {
            padding: 60px 0;
        }

        .bg-light {
            background-color: #f7f9fc;
        }

        .bg-primary {
            background-color: #1f2a44;
        }

        /* =========================
                                                            HERO SECTION
                                                            ========================= */

        .hero-section {
            background: linear-gradient(rgba(31, 42, 68, 0.7),
                    rgba(31, 42, 68, 0.7)),
                url('campus-photo.jpg') center/cover no-repeat;
            text-align: center;
            padding: 100px 20px;
            color: #ffffff;
        }

        .hero-section h1 {
            color: #ffffff;
            font-size: 42px;
        }

        .hero-section p {
            font-size: 18px;
            margin-bottom: 30px;
        }

        /* =========================
                                                            BUTTONS
                                                            ========================= */

        .btn {
            display: inline-block;
            padding: 12px 26px;
            margin: 5px;
            border-radius: 6px;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .btn.primary {
            background-color: #f0b429;
            color: #1f2a44;
        }

        .btn.primary:hover {
            background-color: #d99b1f;
        }

        .btn.secondary {
            background-color: transparent;
            border: 2px solid #ffffff;
            color: #ffffff;
        }

        .btn.secondary:hover {
            background-color: #ffffff;
            color: #1f2a44;
        }

        /* =========================
                                                            LISTS & CONTENT
                                                            ========================= */

        .strength-list,
        .leadership-list,
        .important-links {
            list-style: none;
            padding-left: 0;
        }

        .strength-list li,
        .leadership-list li {
            padding: 10px 0;
            padding-left: 28px;
            position: relative;
        }

        .strength-list li::before {
            content: "✔";
            position: absolute;
            left: 0;
            color: #1a4ed8;
            font-weight: bold;
        }

        /* =========================
                                                            FACILITIES GRID
                                                            ========================= */

        .facility-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
            gap: 20px;
            margin-top: 30px;
        }

        .facility-item {
            background: #c9c7bf;
            padding: 25px;
            text-align: center;
            border-radius: 10px;
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.08);
            font-weight: 600;
        }

        /* =========================
                                                            LINKS SECTION
                                                            ========================= */

        .important-links li {
            margin-bottom: 10px;
        }

        .important-links a {
            color: #ffffff;
            font-weight: 500;
        }

        .section {
            padding: 30px 0;
        }

        /* =========================
                                                            FOOTER
                                                            ========================= */

        .footer {
            background-color: #f1f3f6;
            text-align: center;
            font-size: 14px;
            color: #666;
        }

        .footer p {
            margin: 0;
        }

        /* =========================
                                                            RESPONSIVE DESIGN
                                                            ========================= */

        @media (max-width: 768px) {
            h1 {
                font-size: 30px;
            }

            h2 {
                font-size: 24px;
            }

            .hero-section {
                padding: 70px 20px;
            }

            .btn {
                width: 100%;
                max-width: 280px;
            }
        }
    </style>
    <div class="container my-5">

        <!-- ================= PAGE HEADER ================= -->
        <header class="text-center mb-5">
            <h1 class="fw-bold">Department of Panchakarma</h1>
            <p class="text-muted">
                Detoxification Therapies • Shodhana Chikitsa • Rejuvenation Care • Clinical Panchakarma Training
            </p>
        </header>


        <!-- ================= Department Overview ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Department Overview</h2>

            <p class="text-justify">
                The Department of Panchakarma specializes in classical Ayurvedic purification and
                rejuvenation therapies designed to eliminate toxins, restore physiological balance,
                and enhance overall health. Students receive comprehensive training in Shodhana
                procedures such as Vamana, Virechana, Basti, Nasya, and Raktamokshana, along with
                supportive therapies including Abhyanga, Swedana, and Shirodhara. With dedicated
                OPD and IPD facilities, the department provides real-time clinical exposure and hands-on
                experience in patient care and therapy administration.
            </p>

            <ul>
                <li>Therapeutic detoxification and bio-purification</li>
                <li>Management of chronic and lifestyle disorders</li>
                <li>Preventive and rejuvenation therapies</li>
                <li>Clinical skill development through patient care</li>
            </ul>
        </section>


        <!-- ================= Vision & Mission ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Vision & Mission</h2>

            <div class="row g-4">

                <div class="col-md-6">
                    <div class="card shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-semibold">Vision</h5>
                            <p>
                                To be a leading center for Panchakarma education and therapeutic excellence,
                                promoting safe, scientific, and effective detoxification practices.
                            </p>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="card shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-semibold">Mission</h5>
                            <ul>
                                <li>Provide quality clinical Panchakarma care</li>
                                <li>Enhance practical therapy training</li>
                                <li>Encourage evidence-based therapeutic research</li>
                                <li>Promote holistic and preventive healthcare</li>
                            </ul>
                        </div>
                    </div>
                </div>

            </div>
        </section>


        <!-- ================= Courses ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Courses & Teaching Programs</h2>

            <div class="table-responsive">
                <table class="table table-bordered table-striped align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Program</th>
                            <th>Year</th>
                            <th>Subject</th>
                            <th>Component</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>BAMS</td>
                            <td>Final Professional</td>
                            <td>Panchakarma</td>
                            <td>Theory + Practical</td>
                        </tr>
                        <tr>
                            <td>Internship</td>
                            <td>Clinical Posting</td>
                            <td>Therapy Administration</td>
                            <td>OPD/IPD Training</td>
                        </tr>
                        <tr>
                            <td>Workshops</td>
                            <td>Advanced</td>
                            <td>Specialized Detox Programs</td>
                            <td>Hands-on</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </section>


        <!-- ================= Faculty ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Faculty & Staff</h2>

            <div class="row g-4">

                <div class="col-md-4">
                    <div class="card text-center shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-bold">Dr. R. Gupta</h5>
                            <p class="text-muted mb-1">Professor & Head</p>
                            <small>MD (Panchakarma) | Clinical Specialist</small>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="card text-center shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-bold">Dr. S. Menon</h5>
                            <p class="text-muted mb-1">Assistant Professor</p>
                            <small>Therapeutic Procedures Expert</small>
                        </div>
                    </div>
                </div>

            </div>
        </section>


        <!-- ================= Infrastructure ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Infrastructure & Facilities</h2>

            <div class="row row-cols-1 row-cols-md-2 g-2">
                <div class="col">✔ Dedicated Panchakarma Therapy Rooms</div>
                <div class="col">✔ Male & Female Treatment Units</div>
                <div class="col">✔ Steam Chambers (Swedana Yantra)</div>
                <div class="col">✔ Shirodhara & Abhyanga Rooms</div>
                <div class="col">✔ IPD Wards with Recovery Beds</div>
                <div class="col">✔ Herbal Medicine & Oil Preparation Unit</div>
            </div>
        </section>


        <!-- ================= Teaching Methodology ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Teaching Methodology</h2>

            <ul>
                <li>Live demonstration of therapeutic procedures</li>
                <li>Supervised clinical practice with patients</li>
                <li>Case-based discussions and therapy planning</li>
                <li>Hands-on oil preparation and therapy setup</li>
                <li>Workshops and simulation-based learning</li>
            </ul>
        </section>


        <!-- ================= Research ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Research & Publications</h2>

            <ul>
                <li>Clinical trials on detoxification therapies</li>
                <li>Outcome studies in chronic disease management</li>
                <li>Standardization of Panchakarma protocols</li>
                <li>Research publications in peer-reviewed journals</li>
            </ul>
        </section>


        <!-- ================= Activities ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Academic & Co-Curricular Activities</h2>

            <ul>
                <li>Health and detoxification camps</li>
                <li>Therapy awareness programs</li>
                <li>Guest lectures by experienced clinicians</li>
                <li>Skill enhancement workshops</li>
            </ul>
        </section>


        <!-- ================= Student Support ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Student Support</h2>

            <ul>
                <li>Clinical logbooks and procedure manuals</li>
                <li>Mentorship and bedside training</li>
                <li>Research guidance and dissertation support</li>
                <li>Internship and career counseling</li>
            </ul>
        </section>


        <!-- ================= Gallery ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Photo & Media Gallery</h2>

            <div class="row g-3">
                <div class="col-md-3">
                    <img src="/images/panchakarma1.jpg" class="img-fluid rounded" alt="Abhyanga Therapy Session">
                </div>
                <div class="col-md-3">
                    <img src="/images/panchakarma2.jpg" class="img-fluid rounded" alt="Steam Chamber Treatment">
                </div>
                <div class="col-md-3">
                    <img src="/images/panchakarma3.jpg" class="img-fluid rounded" alt="Shirodhara Procedure">
                </div>
                <div class="col-md-3">
                    <img src="/images/panchakarma4.jpg" class="img-fluid rounded" alt="Clinical Training Session">
                </div>
            </div>
        </section>
    </div>
@endsection
