@extends('layouts.app')

@section('title', 'Department of Dravyaguna | Ayurvedic Pharmacology & Medicinal Plants')
@section('meta_description', 'Department of Dravyaguna (Ayurvedic Pharmacology) specializing in medicinal plants, herbal
    pharmacology, identification of drugs, herbal garden studies, and practical training for BAMS education.')

@section('content')
    <!-- Optional: Add your custom styles here -->
    <style>
        /* =========================
            GLOBAL STYLES
            ========================= */

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', 'Open Sans', Arial, sans-serif;
            font-size: 16px;
            line-height: 1.7;
            color: #333;
            background-color: #ffffff;
        }


        ul {
            list-style-image: url('bullet.png');
            /* Path to your bullet image */
            list-style-type: disc;
            /* Fallback if image is not available */
        }

        h1,
        h2,
        h3 {
            font-family: 'Poppins', 'Montserrat', sans-serif;
            color: #1f2a44;
            margin-bottom: 15px;
        }

        h1 {
            font-size: 36px;
        }

        h2 {
            font-size: 28px;
        }

        p {
            margin-bottom: 15px;
        }

        a {
            text-decoration: none;
            color: #1a4ed8;
        }

        a:hover {
            text-decoration: underline;
        }

        /* =========================
                                                        LAYOUT
                                                        ========================= */

        .container {
            max-width: 1100px;
            margin: auto;
            padding: 0 20px;
        }

        .section {
            padding: 60px 0;
        }

        .bg-light {
            background-color: #f7f9fc;
        }

        .bg-primary {
            background-color: #1f2a44;
        }

        /* =========================
                                                        HERO SECTION
                                                        ========================= */

        .hero-section {
            background: linear-gradient(rgba(31, 42, 68, 0.7),
                    rgba(31, 42, 68, 0.7)),
                url('campus-photo.jpg') center/cover no-repeat;
            text-align: center;
            padding: 100px 20px;
            color: #ffffff;
        }

        .hero-section h1 {
            color: #ffffff;
            font-size: 42px;
        }

        .hero-section p {
            font-size: 18px;
            margin-bottom: 30px;
        }

        /* =========================
                                                        BUTTONS
                                                        ========================= */

        .btn {
            display: inline-block;
            padding: 12px 26px;
            margin: 5px;
            border-radius: 6px;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .btn.primary {
            background-color: #f0b429;
            color: #1f2a44;
        }

        .btn.primary:hover {
            background-color: #d99b1f;
        }

        .btn.secondary {
            background-color: transparent;
            border: 2px solid #ffffff;
            color: #ffffff;
        }

        .btn.secondary:hover {
            background-color: #ffffff;
            color: #1f2a44;
        }

        /* =========================
                                                        LISTS & CONTENT
                                                        ========================= */

        .strength-list,
        .leadership-list,
        .important-links {
            list-style: none;
            padding-left: 0;
        }

        .strength-list li,
        .leadership-list li {
            padding: 10px 0;
            padding-left: 28px;
            position: relative;
        }

        .strength-list li::before {
            content: "✔";
            position: absolute;
            left: 0;
            color: #1a4ed8;
            font-weight: bold;
        }

        /* =========================
                                                        FACILITIES GRID
                                                        ========================= */

        .facility-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
            gap: 20px;
            margin-top: 30px;
        }

        .facility-item {
            background: #c9c7bf;
            padding: 25px;
            text-align: center;
            border-radius: 10px;
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.08);
            font-weight: 600;
        }

        /* =========================
                                                        LINKS SECTION
                                                        ========================= */

        .important-links li {
            margin-bottom: 10px;
        }

        .important-links a {
            color: #ffffff;
            font-weight: 500;
        }

        .section {
            padding: 30px 0;
        }

        /* =========================
                                                        FOOTER
                                                        ========================= */

        .footer {
            background-color: #f1f3f6;
            text-align: center;
            font-size: 14px;
            color: #666;
        }

        .footer p {
            margin: 0;
        }

        /* =========================
                                                        RESPONSIVE DESIGN
                                                        ========================= */

        @media (max-width: 768px) {
            h1 {
                font-size: 30px;
            }

            h2 {
                font-size: 24px;
            }

            .hero-section {
                padding: 70px 20px;
            }

            .btn {
                width: 100%;
                max-width: 280px;
            }
        }
    </style>
    <div class="container my-5">

        <!-- ================= PAGE HEADER ================= -->
        <header class="text-center mb-5">
            <h1 class="fw-bold">Department of Dravyaguna</h1>
            <p class="text-muted">
                Ayurvedic Pharmacology • Medicinal Plants • Herbal Identification • Natural Drug Sciences
            </p>
        </header>


        <!-- ================= Department Overview ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Department Overview</h2>

            <p class="text-justify">
                The Department of Dravyaguna focuses on the scientific study of Ayurvedic pharmacology,
                medicinal plants, and natural drug properties. Students are trained in identification,
                classification, collection, preservation, and therapeutic application of herbal medicines.
                The department integrates classical Ayurvedic knowledge with modern botanical and
                pharmacological approaches to ensure safe, effective, and evidence-based use of herbal drugs.
            </p>

            <ul>
                <li>Medicinal plant identification and taxonomy</li>
                <li>Ayurvedic pharmacodynamics & pharmacotherapeutics</li>
                <li>Herbal drug properties (Rasa, Guna, Virya, Vipaka, Prabhava)</li>
                <li>Field-based botanical and herbarium studies</li>
            </ul>
        </section>


        <!-- ================= Vision & Mission ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Vision & Mission</h2>

            <div class="row g-4">

                <div class="col-md-6">
                    <div class="card shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-semibold">Vision</h5>
                            <p>
                                To become a center of excellence in Ayurvedic pharmacology and herbal sciences,
                                promoting rational and sustainable use of medicinal plants.
                            </p>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="card shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-semibold">Mission</h5>
                            <ul>
                                <li>Deliver hands-on herbal identification training</li>
                                <li>Promote research in medicinal plant sciences</li>
                                <li>Encourage sustainable herbal practices</li>
                                <li>Integrate classical knowledge with modern pharmacology</li>
                            </ul>
                        </div>
                    </div>
                </div>

            </div>
        </section>


        <!-- ================= Courses ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Courses & Teaching Programs</h2>

            <div class="table-responsive">
                <table class="table table-bordered table-striped align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Program</th>
                            <th>Year</th>
                            <th>Subject</th>
                            <th>Component</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>BAMS</td>
                            <td>2nd Professional</td>
                            <td>Dravyaguna Vigyana</td>
                            <td>Theory + Practical</td>
                        </tr>
                        <tr>
                            <td>BAMS</td>
                            <td>2nd Professional</td>
                            <td>Herbal Identification</td>
                            <td>Field Training</td>
                        </tr>
                        <tr>
                            <td>Workshops</td>
                            <td>Advanced</td>
                            <td>Medicinal Plant Research</td>
                            <td>Hands-on</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </section>


        <!-- ================= Faculty ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Faculty & Staff</h2>

            <div class="row g-4">

                <div class="col-md-4">
                    <div class="card text-center shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-bold">Dr. N. Sharma</h5>
                            <p class="text-muted mb-1">Professor & Head</p>
                            <small>MD (Dravyaguna) | Herbal Pharmacology Specialist</small>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="card text-center shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-bold">Dr. L. Rao</h5>
                            <p class="text-muted mb-1">Assistant Professor</p>
                            <small>Botanical Sciences & Field Research Expert</small>
                        </div>
                    </div>
                </div>

            </div>
        </section>


        <!-- ================= Infrastructure ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Infrastructure & Facilities</h2>

            <div class="row row-cols-1 row-cols-md-2 g-2">
                <div class="col">✔ Herbal Garden with 300+ Medicinal Plants</div>
                <div class="col">✔ Pharmacology Laboratory</div>
                <div class="col">✔ Herbarium & Specimen Museum</div>
                <div class="col">✔ Crude Drug Identification Lab</div>
                <div class="col">✔ Drying & Preservation Unit</div>
                <div class="col">✔ Smart Classroom with Digital Tools</div>
            </div>
        </section>


        <!-- ================= Teaching Methodology ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Teaching Methodology</h2>

            <ul>
                <li>Live plant identification and herbarium training</li>
                <li>Laboratory-based drug analysis</li>
                <li>Field visits & botanical excursions</li>
                <li>Interactive seminars and demonstrations</li>
                <li>Clinical application of herbal drugs</li>
            </ul>
        </section>


        <!-- ================= Research ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Research & Publications</h2>

            <ul>
                <li>Medicinal plant cultivation and conservation studies</li>
                <li>Pharmacological evaluation of herbal drugs</li>
                <li>Standardization of Ayurvedic formulations</li>
                <li>Peer-reviewed journal publications</li>
            </ul>
        </section>


        <!-- ================= Activities ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Academic & Co-Curricular Activities</h2>

            <ul>
                <li>Herbal garden development programs</li>
                <li>Plant identification camps</li>
                <li>Guest lectures by pharmacology experts</li>
                <li>Student research presentations</li>
            </ul>
        </section>


        <!-- ================= Student Support ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Student Support</h2>

            <ul>
                <li>Field manuals & plant identification guides</li>
                <li>Practical demonstration notes</li>
                <li>Mentoring & academic counseling</li>
                <li>Research project guidance</li>
            </ul>
        </section>


        <!-- ================= Gallery ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Photo & Media Gallery</h2>

            <div class="row g-3">
                <div class="col-md-3">
                    <img src="/images/dravyaguna1.jpg" class="img-fluid rounded" alt="Herbal Garden">
                </div>
                <div class="col-md-3">
                    <img src="/images/dravyaguna2.jpg" class="img-fluid rounded" alt="Herbarium Specimens">
                </div>
                <div class="col-md-3">
                    <img src="/images/dravyaguna3.jpg" class="img-fluid rounded" alt="Plant Identification Lab">
                </div>
                <div class="col-md-3">
                    <img src="/images/dravyaguna4.jpg" class="img-fluid rounded" alt="Field Visit Training">
                </div>
            </div>
        </section>

    </div>
@endsection
