<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ContactEnquiry;

class ContactController extends Controller
{
    public function submit1(Request $request)
    {
        $request->validate([
            'name'    => 'required|string|max:100',
            'email'   => 'required|email',
            'phone'   => 'required|digits_between:10,12',
            'message' => 'required|string|max:1000',
        ]);

        // Store in DB / Send Email (recommended)
        // ContactEnquiry::create($request->all());

        return back()->with('success',
            'Thank you for contacting RKCAMS. Our team will reach out shortly.'
        );
    }

/**
 * Handle contact form submission
 */
    public function submit(Request $request)
    {
        $validated = $request->validate([
            'name'    => 'required|string|max:100',
            'email'   => 'required|email|max:150',
            'phone'   => 'required|digits_between:10,12',
            'message' => 'required|string|max:1000',
        ]);

        ContactEnquiry::create([
            'name'       => $validated['name'],
            'email'      => $validated['email'],
            'phone'      => $validated['phone'],
            'message'    => $validated['message'],
            'ip_address' => $request->ip(),
            'user_agent' => $request->userAgent(),
        ]);

        return back()->with(
            'success',
            'Thank you for contacting RKCAMS. Our admission team will reach out within 24 working hours.'
        );
    }
}